//Aim:Plot a full wave rectified waveform using Fourier series
//Software version Scilab 5.5.2
//OS Windows 7

clc;
clear;
funcprot(0);                    //creating funtion for Fourier series
function y=f(x),y=1/%pi*sin(x),endfunction           //calculating a0
    a0=intg(0,%pi,f)         //integrating from 0 to %pi for calculating a0
function [a0,A]=fourier(l,n,f)
    for i=1:n
        function b=f1(x,f)
            b=f(x)*cos(i*%pi*x/l)*sin(i*%pi*x/l);  //declaring function An
        endfunction
        A(i)=1/l*intg(0,%pi,f1);          //calculating value of An
    end
    function series=solution(x)
        series=a0/2
        for i=1:n
            series=series+A(i)*cos(i*%pi*x/l);   //suming the serice
        end
    endfunction
    x=0:0.1:6*l;
    plot2d(x,10*(solution(x)-0.068));
    title("output voltage of full wave rectifier")
    ylabel("amplitude")
    xlabel("time")
endfunction
deff('a=f(x)','a=x')  
[a0,A]=fourier(%pi,1,f)       //calling function by asinging value of l and n 
